/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.energy;

import cofh.lib.util.ItemWrapper;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class FurnaceFuelHandler
implements IFuelHandler {
    public static FurnaceFuelHandler instance = new FurnaceFuelHandler();
    private static THashMap<ItemWrapper, Integer> fuels = new THashMap();

    public static void initialize() {
    }

    private FurnaceFuelHandler() {
        if (instance != null) {
            throw new IllegalArgumentException();
        }
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    public int getBurnTime(ItemStack itemStack) {
        if (itemStack == null || !fuels.containsKey((Object)new ItemWrapper(itemStack))) {
            return 0;
        }
        return (Integer)fuels.get((Object)new ItemWrapper(itemStack));
    }

    public static boolean registerFuel(ItemStack itemStack, int n) {
        if (itemStack == null || n <= 0 || fuels.containsKey((Object)new ItemWrapper(itemStack))) {
            return false;
        }
        fuels.put((Object)new ItemWrapper(itemStack), (Object)n);
        return true;
    }

    public static void refreshMap() {
        THashMap tHashMap = new THashMap();
        for (Map.Entry entry : fuels.entrySet()) {
            ItemWrapper itemWrapper = new ItemWrapper(((ItemWrapper)entry.getKey()).item, ((ItemWrapper)entry.getKey()).metadata);
            tHashMap.put((Object)itemWrapper, entry.getValue());
        }
        fuels.clear();
        fuels = tHashMap;
    }
}

